<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">
<link href="images/favicon.png" rel="icon" />
<title>User Dashboard - Guardian Trust - United</title>

<meta name="author" content="">

<!-- Web Fonts
============================================= -->
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap">

<!-- Stylesheet
============================================= -->
<link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/bootstrap.min.css" />
<link rel="stylesheet" type="text/css" href="vendor/font-awesome/css/all.min.css" />
<link rel="stylesheet" type="text/css" href="vendor/bootstrap-select/css/bootstrap-select.min.css" />
<link rel="stylesheet" type="text/css" href="vendor/currency-flags/css/currency-flags.min.css" />
<link rel="stylesheet" type="text/css" href="vendor/daterangepicker/daterangepicker.css" />
<link rel="stylesheet" type="text/css" href="css/stylesheet.css" />
<!-- Colors Css -->
<link id="color-switcher" type="text/css" rel="stylesheet" href="#" />
</head>
<body>
<!-- Preloader -->
<div id="preloader">
  <div data-loader="dual-ring"></div>
</div>
<!-- Preloader End --> 

<!-- Document Wrapper   
============================================= -->
<div id="main-wrapper"> 
  <!-- Header
  ============================================= -->
  <header id="header">
    <div class="container">
      <div class="header-row">
        <div class="header-column justify-content-start"> 
          <!-- Logo
          ============================= -->
          <div class="logo me-3"> <a class="d-flex" href="index.php" title="Guardian Trust - United"><img src="images/prime-1.png" alt="Guardian Trust - United" /></a> </div>
          <!-- Logo end --> 
          <!-- Collapse Button
          ============================== -->
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#header-nav"> <span></span> <span></span> <span></span> </button>
          <!-- Collapse Button end --> 
          
          <!-- Primary Navigation
          ============================== -->
          <nav class="primary-menu navbar navbar-expand-lg">
            <div id="header-nav" class="collapse navbar-collapse">
              <ul class="navbar-nav me-auto">
                <li><a href="index.php">Dashboard</a></li>
                <li><a href="transactions.php">Transactions</a></li>
                <li class="active"><a href="send-money.php">Send/Request</a></li>
                <li><a href="help.html">Help</a></li>
                <li class="dropdown"> <a class="dropdown-toggle" href="#">Features</a>
                  <ul class="dropdown-menu">
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Headers</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="index.php">Light Version (Default)</a></li>
                        <li><a class="dropdown-item" href="feature-header-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-header-primary.html">Primary Version</a></li>
                        <li><a class="dropdown-item" href="index-2.html">Transparent Version</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Navigation DropDown</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="index.php">Light Version (Default)</a></li>
                        <li><a class="dropdown-item" href="feature-navigation-dropdown-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-navigation-dropdown-primary.html">Primary Version</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Second Navigation</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="send-money.php">Default Version</a></li>
                        <li><a class="dropdown-item" href="deposit-money.html">Alternate Version</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Page Headers</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="feature-page-header-left-alignment.html">Left Alignment</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-center-alignment.html">Center Alignment</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-light.html">Light Version</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-primary.html">Primary Version</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-custom-background.html">Custom Background</a></li>
                        <li><a class="dropdown-item" href="feature-page-header-custom-background-with-transparent-header.html">Custom Background 2</a></li>
                      </ul>
                    </li>
                    <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Footer</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="index.php">Light Version Default</a></li>
                        <li><a class="dropdown-item" href="index-2.html">Alternate Version</a></li>
                        <li><a class="dropdown-item" href="feature-footer-dark.html">Dark Version</a></li>
                        <li><a class="dropdown-item" href="feature-footer-primary.html">Primary Version</a></li>
                      </ul>
                    </li>
                    <li><a class="dropdown-item" href="feature-layout-boxed.html">Layout Boxed</a></li>
                  </ul>
                </li>
                <li class="dropdown dropdown-mega"> <a class="dropdown-toggle" href="#">Pages</a>
                  <ul class="dropdown-menu">
                    <li>
                      <div class="dropdown-mega-content">
                        <div class="row">
                          <div class="col-lg"> <span class="sub-title">Homepage</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="index.php">Home Version 1</a></li>
                              <li><a class="dropdown-item" href="index-2.html">Home Version 2</a></li>
                              <li><a class="dropdown-item" href="landing-page-send.html">Landing Page - Send</a></li>
                              <li><a class="dropdown-item" href="landing-page-receive.html">Landing Page - Receive</a></li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Account</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="settings-profile.php">My Profile</a></li>
                              <li><a class="dropdown-item" href="settings-security.php">Security</a></li>
                              <li><a class="dropdown-item" href="settings-payment-methods.php">Payment Methods</a></li>
                              <li><a class="dropdown-item" href="settings-notifications.php">Notifications</a></li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Login</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="login.php">Login Page 1</a></li>
                                  <li><a class="dropdown-item" href="login-2.html">Login Page 2</a></li>
                                  <li><a class="dropdown-item" href="login-3.html">Login Page 3</a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Signup</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="signup.php">Signup Page 1</a></li>
                                  <li><a class="dropdown-item" href="signup-2.html">Signup Page 2 </a></li>
                                  <li><a class="dropdown-item" href="signup-3.html">Signup Page 3 </a></li>
                                </ul>
                              </li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Dashboard</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="index.php">Dashboard</a></li>
                              <li><a class="dropdown-item" href="transactions.php">Transactions</a></li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Send Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="send-money.php">Send Money</a></li>
                                  <li><a class="dropdown-item" href="send-money-confirm.php">Send Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="send-money-success.php">Send Money Success </a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Request Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="request-money.html">Request Money</a></li>
                                  <li><a class="dropdown-item" href="request-money-confirm.html">Request Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="request-money-success.html">Request Money Success </a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Deposit Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="deposit-money.html">Deposit Money</a></li>
                                  <li><a class="dropdown-item" href="deposit-money-confirm.html">Deposit Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="deposit-money-success.html">Deposit Money Success </a></li>
                                </ul>
                              </li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Withdraw Money</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="withdraw-money.html">Withdraw Money</a></li>
                                  <li><a class="dropdown-item" href="withdraw-money-confirm.html">Withdraw Money Confirm</a></li>
                                  <li><a class="dropdown-item" href="withdraw-money-success.html">Withdraw Money Success </a></li>
                                </ul>
                              </li>
                              <li><a class="dropdown-item" href="notifications.php">Notifications</a></li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Blog</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="blog.html">Blog Standard</a></li>
                              <li><a class="dropdown-item" href="blog-grid.html">Blog Grid</a></li>
                              <li><a class="dropdown-item" href="blog-list.html">Blog List</a></li>
                              <li><a class="dropdown-item" href="blog-single.html">Blog Single Right Sidebar</a></li>
                              <li><a class="dropdown-item" href="blog-single-left-sidebar.html">Blog Single Left Sidebar</a></li>
                            </ul>
                          </div>
                          <div class="col-lg"> <span class="sub-title">Others</Span>
                            <ul class="dropdown-mega-submenu">
                              <li><a class="dropdown-item" href="about-us.html">About Us</a></li>
                              <li><a class="dropdown-item" href="fees.html">Fees</a></li>
                              <li><a class="dropdown-item" href="help.html">Help</a></li>
                              <li><a class="dropdown-item" href="contact-us.html">Contact Us</a></li>
                              <li><a class="dropdown-item" href="404.html">404</a></li>
                              <li><a class="dropdown-item" href="coming-soon.html" target="_blank">Coming Soon</a></li>
                              <li class="dropdown"><a class="dropdown-item dropdown-toggle" href="#">Elements</a>
                                <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="elements.html">Elements 1</a></li>
                                  <li><a class="dropdown-item" href="elements-2.html">Elements 2</a></li>
                                </ul>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </li>
                  </ul>
                </li>
              </ul>
            </div>
          </nav>
          <!-- Primary Navigation end --> 
        </div>
        <div class="header-column justify-content-end"> 
          <!-- My Profile
          ============================== -->
          <nav class="login-signup navbar navbar-expand">
            <ul class="navbar-nav">
              <li class="dropdown language"> <a class="dropdown-toggle" href="#">En</a>
                <ul class="dropdown-menu">
                  <li><a class="dropdown-item" href="#">English</a></li>
                  <li><a class="dropdown-item" href="#">French</a></li>
                  <li><a class="dropdown-item" href="#">Русский</a></li>
                  <li><a class="dropdown-item" href="#">简体中文</a></li>
                  <li><a class="dropdown-item" href="#">Türkçe</a></li>
                </ul>
              </li>
              <li class="dropdown notifications"> <a class="dropdown-toggle" href="#"><span class="text-5"><i class="far fa-bell"></i></span><span class="count">3</span></a>
                <ul class="dropdown-menu">
                  <li class="text-center text-3 py-2">Notifications (3)</li>
                  <li class="dropdown-divider mx-n3"></li>
                  <li><a class="dropdown-item" href="#"><i class="fas fa-bell"></i>A new digital FIRC document is available for you to download<span class="text-1 text-muted d-block">22 Jul 2021</span></a></li>
                  <li><a class="dropdown-item" href="#"><i class="fas fa-bell"></i>Updates to our privacy policy. Please read.<span class="text-1 text-muted d-block">04 March 2021</span></a></li>
                  <li><a class="dropdown-item" href="#"><i class="fas fa-bell"></i>Update about Guardian Trust - United fees<span class="text-1 text-muted d-block">18 Feb 2021</span></a></li>
                  <li class="dropdown-divider mx-n3"></li>
                  <li><a class="dropdown-item text-center text-primary px-0" href="notifications.php">See all Notifications</a></li>
                </ul>
              </li>
              <li class="dropdown profile ms-2"> <a class="px-0 dropdown-toggle" href="#"><img class="rounded-circle" src="images/profile-thumb-sm.jpg" alt=""></a>
                <ul class="dropdown-menu">
                  <li class="text-center text-3 py-2">Hi, Smith Rhodes</li>
                  <li class="dropdown-divider mx-n3"></li>
                  <li><a class="dropdown-item" href="settings-profile.php"><i class="fas fa-user"></i>My Profile</a></li>
                  <li><a class="dropdown-item" href="settings-security.php"><i class="fas fa-shield-alt"></i>Security</a></li>
                  <li><a class="dropdown-item" href="settings-payment-methods.php"><i class="fas fa-credit-card"></i>Payment Methods</a></li>
                  <li><a class="dropdown-item" href="settings-notifications.php"><i class="fas fa-bell"></i>Notifications</a></li>
                  <li class="dropdown-divider mx-n3"></li>
                  <li><a class="dropdown-item" href="help.html"><i class="fas fa-life-ring"></i>Need Help?</a></li>
                  <li><a class="dropdown-item" href="#"><i class="fas fa-sign-out-alt"></i>Sign Out</a></li>
                </ul>
              </li>
            </ul>
          </nav>
          <!-- My Profile end --> 
        </div>
      </div>
    </div>
  </header>
  <!-- Header End --> 
  
  <!-- Secondary menu
  ============================================= -->
  <div class="bg-primary">
    <div class="container d-flex justify-content-center">
      <ul class="nav nav-pills alternate nav-lg border-bottom-0">
        <li class="nav-item"> <a class="nav-link" href="send-money.php">Send</a></li>
        <li class="nav-item"> <a class="nav-link active" href="request-money.html">Request</a></li>
      </ul>
    </div>
  </div>
  <!-- Secondary menu end --> 
  
  <!-- Content
  ============================================= -->
  <div id="content" class="py-4">
    <div class="container"> 
      
      <!-- Steps Progress bar -->
      <div class="row mt-4 mb-5">
        <div class="col-lg-11 mx-auto">
          <div class="row widget-steps">
            <div class="col-4 step active">
              <div class="step-name">Details</div>
              <div class="progress">
                <div class="progress-bar"></div>
              </div>
              <a href="#" class="step-dot"></a> </div>
            <div class="col-4 step disabled">
              <div class="step-name">Confirm</div>
              <div class="progress">
                <div class="progress-bar"></div>
              </div>
              <a href="#" class="step-dot"></a> </div>
            <div class="col-4 step disabled">
              <div class="step-name">Success</div>
              <div class="progress">
                <div class="progress-bar"></div>
              </div>
              <a href="#" class="step-dot"></a> </div>
          </div>
        </div>
      </div>
      <h2 class="fw-400 text-center mt-3">Request Money</h2>
      <p class="lead text-center mb-4">Request your payment on anytime, anywhere in the world.</p>
      <div class="row">
        <div class="col-md-9 col-lg-7 col-xl-6 mx-auto">
          <div class="bg-white shadow-sm rounded p-3 pt-sm-4 pb-sm-5 px-sm-5 mb-4">
            <h3 class="text-5 fw-400 mb-3 mb-sm-4">Payer Details</h3>
            <hr class="mx-n3 mx-sm-n5 mb-4">
            <!-- Request Money Form
            ============================================= -->
            <form id="form-send-money" method="post">
              <div class="mb-3">
                <label for="payerName" class="form-label">Name</label>
                <input type="text" value="" class="form-control" data-bv-field="payerName" id="payerName" required placeholder="Enter Name">
              </div>
              <div class="mb-3">
                <label for="emailID" class="form-label">Email</label>
                <input type="text" value="" class="form-control" data-bv-field="emailid" id="emailID" required placeholder="Enter Email Address">
              </div>
              <div class="mb-3">
                <label for="inputCountry" class="form-label">Country</label>
                <select class="form-select" id="inputCountry" name="country_id">
                  <option value="">Select Country</option>
                  <option value="244">Aaland Islands</option>
                  <option value="1">Afghanistan</option>
                  <option value="2">Albania</option>
                  <option value="3">Algeria</option>
                  <option value="4">American Samoa</option>
                  <option value="5">Andorra</option>
                  <option value="6">Angola</option>
                  <option value="7">Anguilla</option>
                  <option value="8">Antarctica</option>
                  <option value="9">Antigua and Barbuda</option>
                  <option value="10">Argentina</option>
                  <option value="11">Armenia</option>
                  <option value="12">Aruba</option>
                  <option value="252">Ascension Island (British)</option>
                  <option value="13">Australia</option>
                  <option value="14">Austria</option>
                  <option value="15">Azerbaijan</option>
                  <option value="16">Bahamas</option>
                  <option value="17">Bahrain</option>
                  <option value="18">Bangladesh</option>
                  <option value="19">Barbados</option>
                  <option value="20">Belarus</option>
                  <option value="21">Belgium</option>
                  <option value="22">Belize</option>
                  <option value="23">Benin</option>
                  <option value="24">Bermuda</option>
                  <option value="25">Bhutan</option>
                  <option value="26">Bolivia</option>
                  <option value="245">Bonaire, Sint Eustatius and Saba</option>
                  <option value="27">Bosnia and Herzegovina</option>
                  <option value="28">Botswana</option>
                  <option value="29">Bouvet Island</option>
                  <option value="30">Brazil</option>
                  <option value="31">British Indian Ocean Territory</option>
                  <option value="32">Brunei Darussalam</option>
                  <option value="33">Bulgaria</option>
                  <option value="34">Burkina Faso</option>
                  <option value="35">Burundi</option>
                  <option value="36">Cambodia</option>
                  <option value="37">Cameroon</option>
                  <option value="38">Canada</option>
                  <option value="251">Canary Islands</option>
                  <option value="39">Cape Verde</option>
                  <option value="40">Cayman Islands</option>
                  <option value="41">Central African Republic</option>
                  <option value="42">Chad</option>
                  <option value="43">Chile</option>
                  <option value="44">China</option>
                  <option value="45">Christmas Island</option>
                  <option value="46">Cocos (Keeling) Islands</option>
                  <option value="47">Colombia</option>
                  <option value="48">Comoros</option>
                  <option value="49">Congo</option>
                  <option value="50">Cook Islands</option>
                  <option value="51">Costa Rica</option>
                  <option value="52">Cote D'Ivoire</option>
                  <option value="53">Croatia</option>
                  <option value="54">Cuba</option>
                  <option value="246">Curacao</option>
                  <option value="55">Cyprus</option>
                  <option value="56">Czech Republic</option>
                  <option value="237">Democratic Republic of Congo</option>
                  <option value="57">Denmark</option>
                  <option value="58">Djibouti</option>
                  <option value="59">Dominica</option>
                  <option value="60">Dominican Republic</option>
                  <option value="61">East Timor</option>
                  <option value="62">Ecuador</option>
                  <option value="63">Egypt</option>
                  <option value="64">El Salvador</option>
                  <option value="65">Equatorial Guinea</option>
                  <option value="66">Eritrea</option>
                  <option value="67">Estonia</option>
                  <option value="68">Ethiopia</option>
                  <option value="69">Falkland Islands (Malvinas)</option>
                  <option value="70">Faroe Islands</option>
                  <option value="71">Fiji</option>
                  <option value="72">Finland</option>
                  <option value="74">France, Metropolitan</option>
                  <option value="75">French Guiana</option>
                  <option value="76">French Polynesia</option>
                  <option value="77">French Southern Territories</option>
                  <option value="126">FYROM</option>
                  <option value="78">Gabon</option>
                  <option value="79">Gambia</option>
                  <option value="80">Georgia</option>
                  <option value="81">Germany</option>
                  <option value="82">Ghana</option>
                  <option value="83">Gibraltar</option>
                  <option value="84">Greece</option>
                  <option value="85">Greenland</option>
                  <option value="86">Grenada</option>
                  <option value="87">Guadeloupe</option>
                  <option value="88">Guam</option>
                  <option value="89">Guatemala</option>
                  <option value="256">Guernsey</option>
                  <option value="90">Guinea</option>
                  <option value="91">Guinea-Bissau</option>
                  <option value="92">Guyana</option>
                  <option value="93">Haiti</option>
                  <option value="94">Heard and Mc Donald Islands</option>
                  <option value="95">Honduras</option>
                  <option value="96">Hong Kong</option>
                  <option value="97">Hungary</option>
                  <option value="98">Iceland</option>
                  <option value="99">India</option>
                  <option value="100">Indonesia</option>
                  <option value="101">Iran (Islamic Republic of)</option>
                  <option value="102">Iraq</option>
                  <option value="103">Ireland</option>
                  <option value="254">Isle of Man</option>
                  <option value="104">Israel</option>
                  <option value="105">Italy</option>
                  <option value="106">Jamaica</option>
                  <option value="107">Japan</option>
                  <option value="257">Jersey</option>
                  <option value="108">Jordan</option>
                  <option value="109">Kazakhstan</option>
                  <option value="110">Kenya</option>
                  <option value="111">Kiribati</option>
                  <option value="113">Korea, Republic of</option>
                  <option value="253">Kosovo, Republic of</option>
                  <option value="114">Kuwait</option>
                  <option value="115">Kyrgyzstan</option>
                  <option value="116">Lao People's Democratic Republic</option>
                  <option value="117">Latvia</option>
                  <option value="118">Lebanon</option>
                  <option value="119">Lesotho</option>
                  <option value="120">Liberia</option>
                  <option value="121">Libyan Arab Jamahiriya</option>
                  <option value="122">Liechtenstein</option>
                  <option value="123">Lithuania</option>
                  <option value="124">Luxembourg</option>
                  <option value="125">Macau</option>
                  <option value="127">Madagascar</option>
                  <option value="128">Malawi</option>
                  <option value="129">Malaysia</option>
                  <option value="130">Maldives</option>
                  <option value="131">Mali</option>
                  <option value="132">Malta</option>
                  <option value="133">Marshall Islands</option>
                  <option value="134">Martinique</option>
                  <option value="135">Mauritania</option>
                  <option value="136">Mauritius</option>
                  <option value="137">Mayotte</option>
                  <option value="138">Mexico</option>
                  <option value="139">Micronesia, Federated States of</option>
                  <option value="140">Moldova, Republic of</option>
                  <option value="141">Monaco</option>
                  <option value="142">Mongolia</option>
                  <option value="242">Montenegro</option>
                  <option value="143">Montserrat</option>
                  <option value="144">Morocco</option>
                  <option value="145">Mozambique</option>
                  <option value="146">Myanmar</option>
                  <option value="147">Namibia</option>
                  <option value="148">Nauru</option>
                  <option value="149">Nepal</option>
                  <option value="150">Netherlands</option>
                  <option value="151">Netherlands Antilles</option>
                  <option value="152">New Caledonia</option>
                  <option value="153">New Zealand</option>
                  <option value="154">Nicaragua</option>
                  <option value="155">Niger</option>
                  <option value="156">Nigeria</option>
                  <option value="157">Niue</option>
                  <option value="158">Norfolk Island</option>
                  <option value="112">North Korea</option>
                  <option value="159">Northern Mariana Islands</option>
                  <option value="160">Norway</option>
                  <option value="161">Oman</option>
                  <option value="162">Pakistan</option>
                  <option value="163">Palau</option>
                  <option value="247">Palestinian Territory, Occupied</option>
                  <option value="164">Panama</option>
                  <option value="165">Papua New Guinea</option>
                  <option value="166">Paraguay</option>
                  <option value="167">Peru</option>
                  <option value="168">Philippines</option>
                  <option value="169">Pitcairn</option>
                  <option value="170">Poland</option>
                  <option value="171">Portugal</option>
                  <option value="172">Puerto Rico</option>
                  <option value="173">Qatar</option>
                  <option value="174">Reunion</option>
                  <option value="175">Romania</option>
                  <option value="176">Russian Federation</option>
                  <option value="177">Rwanda</option>
                  <option value="178">Saint Kitts and Nevis</option>
                  <option value="179">Saint Lucia</option>
                  <option value="180">Saint Vincent and the Grenadines</option>
                  <option value="181">Samoa</option>
                  <option value="182">San Marino</option>
                  <option value="183">Sao Tome and Principe</option>
                  <option value="184">Saudi Arabia</option>
                  <option value="185">Senegal</option>
                  <option value="243">Serbia</option>
                  <option value="186">Seychelles</option>
                  <option value="187">Sierra Leone</option>
                  <option value="188">Singapore</option>
                  <option value="189">Slovak Republic</option>
                  <option value="190">Slovenia</option>
                  <option value="191">Solomon Islands</option>
                  <option value="192">Somalia</option>
                  <option value="193">South Africa</option>
                  <option value="194">South Georgia &amp; South Sandwich Islands</option>
                  <option value="248">South Sudan</option>
                  <option value="195">Spain</option>
                  <option value="196">Sri Lanka</option>
                  <option value="249">St. Barthelemy</option>
                  <option value="197">St. Helena</option>
                  <option value="250">St. Martin (French part)</option>
                  <option value="198">St. Pierre and Miquelon</option>
                  <option value="199">Sudan</option>
                  <option value="200">Suriname</option>
                  <option value="201">Svalbard and Jan Mayen Islands</option>
                  <option value="202">Swaziland</option>
                  <option value="203">Sweden</option>
                  <option value="204">Switzerland</option>
                  <option value="205">Syrian Arab Republic</option>
                  <option value="206">Taiwan</option>
                  <option value="207">Tajikistan</option>
                  <option value="208">Tanzania, United Republic of</option>
                  <option value="209">Thailand</option>
                  <option value="210">Togo</option>
                  <option value="211">Tokelau</option>
                  <option value="212">Tonga</option>
                  <option value="213">Trinidad and Tobago</option>
                  <option value="255">Tristan da Cunha</option>
                  <option value="214">Tunisia</option>
                  <option value="215">Turkey</option>
                  <option value="216">Turkmenistan</option>
                  <option value="217">Turks and Caicos Islands</option>
                  <option value="218">Tuvalu</option>
                  <option value="219">Uganda</option>
                  <option value="220">Ukraine</option>
                  <option value="221">United Arab Emirates</option>
                  <option value="222">United Kingdom</option>
                  <option value="223">United States</option>
                  <option value="224">United States Minor Outlying Islands</option>
                  <option value="225">Uruguay</option>
                  <option value="226">Uzbekistan</option>
                  <option value="227">Vanuatu</option>
                  <option value="228">Vatican City State (Holy See)</option>
                  <option value="229">Venezuela</option>
                  <option value="230">Viet Nam</option>
                  <option value="231">Virgin Islands (British)</option>
                  <option value="232">Virgin Islands (U.S.)</option>
                  <option value="233">Wallis and Futuna Islands</option>
                  <option value="234">Western Sahara</option>
                  <option value="235">Yemen</option>
                  <option value="238">Zambia</option>
                  <option value="239">Zimbabwe</option>
                </select>
              </div>
              <div class="mb-3">
                <label for="amount" class="form-label">Amount</label>
                <div class="input-group">
                  <span class="input-group-text">$</span>
                  <input type="text" class="form-control" data-bv-field="amount" id="amount" value="1,000.00" placeholder="">
                  <span class="input-group-text p-0">
                    <select id="recipientCurrency" data-style="form-select bg-transparent border-0" data-container="body" data-live-search="true" class="selectpicker form-control bg-transparent" required="">
                      <optgroup label="Popular Currency">
                      <option data-icon="currency-flag currency-flag-usd me-1" data-subtext="United States dollar" value="">USD</option>
                      <option data-icon="currency-flag currency-flag-aud me-1" data-subtext="Australian dollar" selected="selected"  value="">AUD</option>
                      <option data-icon="currency-flag currency-flag-inr me-1" data-subtext="Indian rupee" value="">INR</option>
                      </optgroup>
                      <option value="" data-divider="true">divider</option>
                      <optgroup label="Other Currency">
                      <option data-icon="currency-flag currency-flag-aed me-1" data-subtext="United Arab Emirates dirham" value="">AED</option>
                      <option data-icon="currency-flag currency-flag-ars me-1" data-subtext="Argentine peso" value="">ARS</option>
                      <option data-icon="currency-flag currency-flag-aud me-1" data-subtext="Australian dollar" value="">AUD</option>
                      <option data-icon="currency-flag currency-flag-bdt me-1" data-subtext="Bangladeshi taka" value="">BDT</option>
                      <option data-icon="currency-flag currency-flag-bgn me-1" data-subtext="Bulgarian lev" value="">BGN</option>
                      <option data-icon="currency-flag currency-flag-brl me-1" data-subtext="Brazilian real" value="">BRL</option>
                      <option data-icon="currency-flag currency-flag-cad me-1" data-subtext="Canadian dollar" value="">CAD</option>
                      <option data-icon="currency-flag currency-flag-chf me-1" data-subtext="Swiss franc" value="">CHF</option>
                      <option data-icon="currency-flag currency-flag-clp me-1" data-subtext="Chilean peso" value="">CLP</option>
                      <option data-icon="currency-flag currency-flag-cny me-1" data-subtext="Chinese yuan" value="">CNY</option>
                      <option data-icon="currency-flag currency-flag-czk me-1" data-subtext="Czech koruna" value="">CZK</option>
                      <option data-icon="currency-flag currency-flag-dkk me-1" data-subtext="Danish krone" value="">DKK</option>
                      <option data-icon="currency-flag currency-flag-egp me-1" data-subtext="Egyptian pound" value="">EGP</option>
                      <option data-icon="currency-flag currency-flag-eur me-1" data-subtext="Euro" value="">EUR</option>
                      <option data-icon="currency-flag currency-flag-gbp me-1" data-subtext="British pound" value="">GBP</option>
                      <option data-icon="currency-flag currency-flag-gel me-1" data-subtext="Georgian lari" value="">GEL</option>
                      <option data-icon="currency-flag currency-flag-ghs me-1" data-subtext="Ghanaian cedi" value="">GHS</option>
                      <option data-icon="currency-flag currency-flag-hkd me-1" data-subtext="Hong Kong dollar" value="">HKD</option>
                      <option data-icon="currency-flag currency-flag-hrk me-1" data-subtext="Croatian kuna" value="">HRK</option>
                      <option data-icon="currency-flag currency-flag-huf me-1" data-subtext="Hungarian forint" value="">HUF</option>
                      <option data-icon="currency-flag currency-flag-idr me-1" data-subtext="Indonesian rupiah" value="">IDR</option>
                      <option data-icon="currency-flag currency-flag-ils me-1" data-subtext="Israeli shekel" value="">ILS</option>
                      <option data-icon="currency-flag currency-flag-inr me-1" data-subtext="Indian rupee" value="">INR</option>
                      <option data-icon="currency-flag currency-flag-jpy me-1" data-subtext="Japanese yen" value="">JPY</option>
                      <option data-icon="currency-flag currency-flag-kes me-1" data-subtext="Kenyan shilling" value="">KES</option>
                      <option data-icon="currency-flag currency-flag-krw me-1" data-subtext="South Korean won" value="">KRW</option>
                      <option data-icon="currency-flag currency-flag-lkr me-1" data-subtext="Sri Lankan rupee" value="">LKR</option>
                      <option data-icon="currency-flag currency-flag-mad me-1" data-subtext="Moroccan dirham" value="">MAD</option>
                      <option data-icon="currency-flag currency-flag-mxn me-1" data-subtext="Mexican peso" value="">MXN</option>
                      <option data-icon="currency-flag currency-flag-myr me-1" data-subtext="Malaysian ringgit" value="">MYR</option>
                      <option data-icon="currency-flag currency-flag-ngn me-1" data-subtext="Nigerian naira" value="">NGN</option>
                      <option data-icon="currency-flag currency-flag-nok me-1" data-subtext="Norwegian krone" value="">NOK</option>
                      <option data-icon="currency-flag currency-flag-npr me-1" data-subtext="Nepalese rupee" value="">NPR</option>
                      <option data-icon="currency-flag currency-flag-nzd me-1" data-subtext="New Zealand dollar" value="">NZD</option>
                      <option data-icon="currency-flag currency-flag-pen me-1" data-subtext="Peruvian nuevo sol" value="">PEN</option>
                      <option data-icon="currency-flag currency-flag-php me-1" data-subtext="Philippine peso" value="">PHP</option>
                      <option data-icon="currency-flag currency-flag-pkr me-1" data-subtext="Pakistani rupee" value="">PKR</option>
                      <option data-icon="currency-flag currency-flag-pln me-1" data-subtext="Polish złoty" value="">PLN</option>
                      <option data-icon="currency-flag currency-flag-ron me-1" data-subtext="Romanian leu" value="">RON</option>
                      <option data-icon="currency-flag currency-flag-rub me-1" data-subtext="Russian rouble" value="">RUB</option>
                      <option data-icon="currency-flag currency-flag-sek me-1" data-subtext="Swedish krona" value="">SEK</option>
                      <option data-icon="currency-flag currency-flag-sgd me-1" data-subtext="Singapore dollar" value="">SGD</option>
                      <option data-icon="currency-flag currency-flag-thb me-1" data-subtext="Thai baht" value="">THB</option>
                      <option data-icon="currency-flag currency-flag-try me-1" data-subtext="Turkish lira" value="">TRY</option>
                      <option data-icon="currency-flag currency-flag-uah me-1" data-subtext="Ukrainian hryvnia" value="">UAH</option>
                      <option data-icon="currency-flag currency-flag-ugx me-1" data-subtext="Ugandan shilling" value="">UGX</option>
                      <option data-icon="currency-flag currency-flag-vnd me-1" data-subtext="Vietnamese dong" value="">VND</option>
                      <option data-icon="currency-flag currency-flag-zar me-1" data-subtext="South African rand" value="">ZAR</option>
                      </optgroup>
                    </select>
                    </span>
                </div>
              </div>
              <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" rows="4" id="description" required placeholder="Payment Description"></textarea>
              </div>
              <div class="mb-3">
                <label for="paymentDue" class="form-label">Payment due by</label>
                <div class="position-relative">
                  <input id="paymentDue" value="" type="text" class="form-control" required placeholder="Payment Due Date">
                  <span class="icon-inside"><i class="fas fa-calendar-alt"></i></span> </div>
              </div>
              <div class="d-grid mt-4"><button class="btn btn-primary">Continue</button></div>
            </form>
            <!-- Request Money Form end --> 
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Content end --> 
  
  <!-- Footer
  ============================================= -->
  <footer id="footer">
    <div class="container">
      <div class="row">
        <div class="col-lg d-lg-flex align-items-center">
          <ul class="nav justify-content-center justify-content-lg-start text-3">
            <li class="nav-item"> <a class="nav-link active" href="#">About Us</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Support</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Help</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Careers</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Affiliate</a></li>
            <li class="nav-item"> <a class="nav-link" href="#">Fees</a></li>
          </ul>
        </div>
        <div class="col-lg d-lg-flex justify-content-lg-end mt-3 mt-lg-0">
          <ul class="social-icons justify-content-center">
            <li class="social-icons-facebook"><a data-bs-toggle="tooltip" href="http://www.facebook.com/" target="_blank" title="Facebook"><i class="fab fa-facebook-f"></i></a></li>
            <li class="social-icons-twitter"><a data-bs-toggle="tooltip" href="http://www.twitter.com/" target="_blank" title="Twitter"><i class="fab fa-twitter"></i></a></li>
            <li class="social-icons-google"><a data-bs-toggle="tooltip" href="http://www.google.com/" target="_blank" title="Google"><i class="fab fa-google"></i></a></li>
            <li class="social-icons-youtube"><a data-bs-toggle="tooltip" href="http://www.youtube.com/" target="_blank" title="Youtube"><i class="fab fa-youtube"></i></a></li>
          </ul>
        </div>
      </div>
      <div class="footer-copyright pt-3 pt-lg-2 mt-2">
        <div class="row">
          <div class="col-lg">
            <p class="text-center text-lg-start mb-2 mb-lg-0">Copyright &copy; <?php echo date("Y"); ?> <a>Guardian Trust - United</a>. All Rights Reserved.</p>
          </div>
          <div class="col-lg d-lg-flex align-items-center justify-content-lg-end">
            <ul class="nav justify-content-center">
              <li class="nav-item"> <a class="nav-link active" href="#">Security</a></li>
              <li class="nav-item"> <a class="nav-link" href="#">Terms</a></li>
              <li class="nav-item"> <a class="nav-link" href="#">Privacy</a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </footer>
  <!-- Footer end --> 
  
</div>
<!-- Document Wrapper end --> 

<!-- Back to Top
============================================= --> 
<a id="back-to-top" data-bs-toggle="tooltip" title="Back to Top" href="javascript:void(0)"><i class="fa fa-chevron-up"></i></a> 

<!-- Styles Switcher -->

<!-- Styles Switcher End --> 

<!-- Script --> 
<script src="vendor/jquery/jquery.min.js"></script> 
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script> 
<script src="vendor/bootstrap-select/js/bootstrap-select.min.js"></script> 
<script src="vendor/daterangepicker/moment.min.js"></script> 
<script src="vendor/daterangepicker/daterangepicker.js"></script> 
<script>
$(function() {
 'use strict';
  // Payment due by
  $('#paymentDue').daterangepicker({
	singleDatePicker: true,
	minDate: moment(),
	autoUpdateInput: false,
	}, function(chosen_date) {
  $('#paymentDue').val(chosen_date.format('MM-DD-YYYY'));
  });
  });
</script> 
<!-- Style Switcher --> 
<script src="js/switcher.min.js"></script> 
<script src="js/theme.js"></script>
</body>
</html>